# 第三章 开源项目发展现状

从开源项目活跃度与影响力以及各个技术领域如人工智能、大数据、云计算等与开源的融合现状可见，中国开源项目正处于快速发展阶段。在国家政策的带动及开源文化的影响下，各企业积极拥抱开源，贡献开源项目、建设开源社区、培养开源人才、探索产业创新。

## 3.1 GitHub中国项目活跃度及趋势

GitHub作为全球最大的开源社区，其项目数据极具参考价值。据全球GitHub事件日志、活跃仓库、活跃开发者五年趋势图（见图15）显示，GitHub仓库与开发者活跃数量稳步上涨，事件日志总量在2021年突破了10亿条。通过统计全域GitHub事件日志，可观测到近5年全球开源的总体活跃情况和活跃仓库数量都在明显上升。特别是COVID-19疫情爆发已来，尽管影响了人们的工作与生活，但是没有阻止开源事业的发展。与此同时，如图16所示，中国开源发展也进入平稳增长期，随着2021年国家对开源的支持政策出台和开放原子开源基金会的成立，促使各大企业相继拥抱开源、大力投入，并涌现出一批以开源为主的初创企业。可以预见，在不久的将来，中国开源的发展将进入新的快速增长期。

![](https://img-blog.csdnimg.cn/165d9b594820479ca56365db9f3edb41.png)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图15 全球 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图</span>

![](https://img-blog.csdnimg.cn/999b036ec86f440baf242f1700ce5671.png)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图16 中国 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图</span>

为了更好地展现中国企业在全球范围内的开源贡献水平，本节通过对比美国与中国活跃度排名前十的开源贡献企业（见表5）、美国与中国开源影响力排名前十的企业（见表6）进行分析。

美国的大型互联网企业在开源活跃度与影响力方面持续领先，微软由于使用GitHub作为大部分团队的日常开发平台，故项目数量较大，总活跃度第一，Google次之。而在项目平均活跃度方面，Google依然是世界上平均活跃度最高的企业。在中国企业的开源活跃度排名中，阿里巴巴的项目数量和总活跃度均为榜首，但整体项目体量和活跃度总量距离Google等企业还有一定的差距。不过，中国的开源初创企业和项目则表现抢眼，根据项目平均活跃度可见，PingCAP、百度、青云、悦数科技（vesoft）等企业的项目都脱颖而出。

![在这里插入图片描述](https://img-blog.csdnimg.cn/5d81f9502166403cb4cc470e7fa9dd41.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表5 美国企业开源活跃度 Top 10</span>

![在这里插入图片描述](https://img-blog.csdnimg.cn/7db9c59a35b04756ae18280f34d28a65.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表6 中国企业开源活跃度Top 10</span>

从总体活跃度指标来看，虽然在开源项目的体量方面，中国较美国有一定落差，但在项目平均活跃度方面则水平相当，因此，中国需要继续大力孵化、培育优秀开源项目。

企业的开源影响力指标更关注开发者生态，对比美国与中国的企业在影响力指标（表7与表8）可见，美国的开源项目数量更多，二者在项目平均影响力的表现则相当。在中国企业中，有赞的开源项目影响力最高，从一众企业中脱颖而出，这得益于其主要的开源项目vant良好的开发者生态。

![在这里插入图片描述](https://img-blog.csdnimg.cn/8bc2cc94111748e6b833fbf32b928408.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表7 美国企业影响力Top 10</span>

![在这里插入图片描述](https://img-blog.csdnimg.cn/a369e0cc67a2415895ecbfc944f8af05.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表8 中国企业影响力Top 10</span>

此外，从中国企业近5年的开源发展趋势，包括活跃度趋势（见图17）与影响力趋势（见图18）来看，阿里巴巴、百度、蚂蚁集团长期名列前茅。其中，阿里巴巴的开源活跃度与影响力长期排名榜首，百度近几年对开源的投入与贡献显著增加。值得一提的是，初创企业PingCAP，其开源活跃度与影响力一直稳居榜单第四。

![](https://img-blog.csdnimg.cn/9d80d45f0dd8415b878400d3251cf9bd.png)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图17 中国企业开源活跃度Top 10（2017–2021年）</span>

![](https://img-blog.csdnimg.cn/d70c9ec6b4d640c9a1cfa8400e3c1793.png)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图18 中国企业开源影响力Top 10（2017-2021年）</span>

同样的，根据开源项目活跃度和影响力，相较GitHub全球开源项目和中国开源项目的Top 20（表9与表10），可见从单个项目而言，中国主导的开源项目的活跃度和影响力距离全球顶级开源项目的活跃度与影响力还有一定差距（表11与表12），特别是在影响力方面，需要国内企业最大限度地融入全球开源生态，发展中国开源项目。

![在这里插入图片描述](https://img-blog.csdnimg.cn/ebc0bb979a2c41cf9e032e37144f2046.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表9 GitHub全球项目活跃度Top 20</span>

![在这里插入图片描述](https://img-blog.csdnimg.cn/59e46f40427a48eeaac406abf74194ba.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表10 GitHub 中国项目活跃度 Top 20</span>

![在这里插入图片描述](https://img-blog.csdnimg.cn/e83dcb96093944b99983b188d68bf3bd.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表11 GitHub全球项目影响力Top 20</span>

![在这里插入图片描述](https://img-blog.csdnimg.cn/a5fe46bd7c2145d785a514e41f513661.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表12 GitHub中国项目影响力Top 20</span>


## 3.2 中国重点领域开源项目发展现状

在国家政策、资本力量、商业组织与科研机构等多方利好形势下，人工智能、大数据、云计算、工业互联网、区块链等技术快速发展，并被广泛应用。与此同时，各技术领域受开源文化影响，秉承开源、开放的态度建设多层次人才培养体系、构筑产业集群优势、加快推动应用发展、促进产业融合创新。如今，人工智能、大数据、云计算、工业互联网、区块链等技术领域结合开源，呈现出技术与产业协同发展的新局面。

### 3.2.1 开源与基础设施

#### 操作系统

当前，国内基于Linux发行版构建的操作系统层出不穷，加速了国产操作系统的发展，国内开发者对操作系统的关注度也日趋增长。由于自研操作系统的投入巨大且研发、维护、更新周期长，能形成一定生态规模的操作系统在全球屈指可数，能打破已有市场的新型操作系统更少。因此，多年来研发操作系统及通过自研操作系统盈利的国内企业极少。即使是对外声明做（通用）操作系统研发的公司，绝大部分也是建立在Linux官方内核或某Linux发行版上的下游企业。这导致企业难以主动投入足够的资金和人力进行操作系统的研发工作。

不过，近年来随着开源声势在国内日渐浩大，操作系统领域也在拥抱开源的情况下，诞生了一批开源操作系统，比如，华为主导的openEuler服务器领域操作系统和OpenHarmony移动终端、物联网操作系统，再比如，阿里巴巴主导的OpenAnolis服务器操作系统、腾讯主导的OpenCloudOS服务器操作系统。众多操作系统领域的利益相关方也形成了一种共识：开源有助于开放创新，源代码公开可供修改学习，开源还能帮助企业塑造品牌影响力。

当国内IT领先企业发展到一定阶段，采用外来的操作系统会受到功能、性能和安全可靠等特定需求的限制，而这些企业已经有一定的实力进行操作系统研发方面的投入，比如，通过改进或定制Linux等操作系统来提升自身业务的发展。而且，新兴领域如人工智能、物联网等吸引了大量的资金，由于现有操作系统不能充分满足这些领域的深入发展需求，进而吸引了一批新玩家投入面向新兴领域的操作系统的研究。

目前，操作系统的边界已经被极大地扩展了。在产业界，操作系统正努力向国际先进水平靠近。例如：

* 国内的openEuler（Linux）操作系统、龙蜥操作系统、麒麟操作系统、统信操作系统等，与国外的Ubuntu（Linux）操作系统、RedHat（Linux）操作系统、SUSE（Linux）操作系统类似，都是基于Linux操作系统内核的多种软件集合形成的Linux发行版；
* 运行在手机上的OpenHarmony操作系统与Android操作系统类似，都是基于Linux操作系统内核，提供适合触摸交互的图形交互软件框架和移动终端共性服务的移动终端类操作系统；
* 运行在嵌入式设备上的OpenHarmony操作系统、RT-Thread、SylixOS等则属于实时操作系统（RTOS）范围，除了在传统工业控制领域继续发展外，还在互联网、物联网等领域快速突破，形成了开发环境、分布式协同等更广泛的系统级支持；
* 在自动驾驶领域，不少国内造车企业（如理想、蔚来、小鹏等）与国外的特斯拉从多方位进行竞争，开展了面向新型电子驾驶、自动驾驶的操作系统研发，形成了新的操作系统产业热点。


#### 芯片

相比价值已达数百亿美元的开源软件生态，芯片虽已成为支撑各行各业的基石，但开源芯片仍处于起步阶段。在处理器芯片领域，基于开源指令集 RISC-Ⅴ的开源芯片生态正在快速崛起，为开源芯片生态的创新降低了技术门槛，为包括中国在内的广大发展中国家突破中央处理器（CPU）芯片领域的技术壁垒和市场壁垒带来新机遇。虽然 RISC-Ⅴ在中国发展得如火如荼，但基于 RISC-Ⅴ构建开源芯片生态仍面临若干挑战，开源处理器（L2 级）仅仅是一个必要条件，还需要软件、应用、人才、资金等多种关键要素。例如，相应的开发工具链有待完善，底层芯片与系统软件的优化程度不高，产业链的上下游尚未形成合力，碎片化程度高等问题还比较突出。

国内使用较为广泛的芯片开源项目首先是阿里巴巴2021年发布的基于RISC-V的开源玄铁系列处理器以及一系列工具和系统软件，其作为全栈开源系列处理器和基础软件，将促进RISC-V体系结构的成熟，并有助于加速RISC-V软硬件技术在人工智能物联网（AIoT）时代的发展。其次，合芯科技推出的基于OpenPOWER基金会（Linux基金会旗下）的POWER开源指令集的HP系列高性能处理器芯片已经量产，它采用先进工艺及SMT8超线程技术以更低功耗提供更高性能，支持业内最先进的存储及互联技术，集成ISO国际密码标准等业界主流密码算法，其先进的RAS设计等技术提供高达5个“九”的可靠性，是定位面向科学计算、存储、数据库、云计算、人工智能、大数据、核心金融交易系统的开源指令集处理器芯片。此外，还有开源芯片研究院推出的代号为“南湖”的芯片，已经流片，支持双通道DDR内存以及PCIe、USB、HDMI等功能。

中国作为制造业大国，需大量进口芯片，但受国际局势影响，全球陆续出现的“缺芯潮”。中国也面临“卡脖子”困境，甚至有极大的供应链风险，导致汽车制造等重要工业领域停工停产。这需要整个供应链包括EDA业者、芯片设备、IC设计、IC制造、封装、测试之间进一步加强合作，为中国企业的芯片供应链安全提供保障。

#### 数据库

早在20世纪50年代，互联网技术（ARPANET）的先驱们就十分推崇同行评审和开放反馈，用户组通过共享源代码，相互扶持并激发创新，到20世纪90年代互联网诞生时，协作、开放、创新的价值观就已植根于互联网的内核之中。

在数据库技术领域，始于20世纪70年代的Ingres项目，代码使用BSD许可证分发，在其基础之上，以各种形式演绎出包括Sybase、Microsoft SQL Server、NonStop SQL、Informix、PostgreSQL等著名产品，成为数据库历史上最成功的项目之一。

本质上，开源软件和闭源软件都只是一种软件研发和消费模式，在不同时期和场景有着各自独特的竞争力和优势体现。时至今日，开源软件依托其社区开发模式，能更快地实现产品迭代和用户触达，进而形成免费软件结合付费服务的业务模式，并进一步通过云获得价值回报，MongoDB等数据库都在探索这一模式。此外，从市场竞争战略来看，软件开源已经成为后来者扩大其市场影响力、追赶头部企业的重要手段。

国内开源数据库的发展，经历了借鉴、发展、创新的全历程，早期国产数据库的探索者人大金仓就是以PostgreSQL为基础，而NewSQL的代表产品TiDB则是源自2013年Google Spanner/F1论文的技术实现，更多的NoSQL数据库也相继开源，如悦数科技在2019年开源了它的原生图数据库Nebula Graph的alpha版。自2019年以来，国内开源数据库领域快速发展，大事件频现，推动国内开源产业的蓬勃兴盛。

![](https://img-blog.csdnimg.cn/8a90a584727e4edba43e4df5555cd4e9.png)<br/><span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;">图19 DB-Engines 商业数据库和开源数据库流行度趋势对比</span>

据DB-Engines的数据显示，自2021年1月，开源数据库的流行度首次超越商业数据库，并持续领先（见图19）。全球383款数据库中，开源数据库占据51.7%，排名前十的数据库中，开源数据库占据六席。据墨天轮的中国数据库流行度排行榜，198个数据库产品中包含13个开源的数据库产品，而榜单的前十名就有5个开源产品。从数据库开源项目的现状来看，全球最受欢迎的两种开源数据库MySQL与PostgreSQL是一系列数据库产品衍生的基础，中国数据库流行度排行榜中，源自MySQL和PostgreSQL的数据库数量分别为12和18。在今天的数据库领域，开源已经成为主要的趋势和潮流。

表13为被广泛使用的中国主导的开源数据库。

![在这里插入图片描述](https://img-blog.csdnimg.cn/ec09cc8f3098479bbbc6e0fb4808cddb.jpeg#pic_center)<br/><span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;">表13 中国主导的开源数据库</span>

### 3.2.2 开源与人工智能
	 
据艾瑞咨询分析，2021年人工智能核心产业规模预计达到1998亿元规模，相应规模将于2026年超过6000亿元，2021-2026年的复合年均增长率为24.8%，人工智能产业正从发展期向成熟期过渡，除人工智能芯片外的细分技术赛道产业已跨过高速增长期，步入了稳步增长阶段。

在产业增长期，人工智能领域的企业与研究人员正通过结合开源，促使各环节提升经济生产活动效能。如今，在AI模型规模更加庞大、算法架构更为复杂、所需训练数据更为巨大和繁杂的情况下，开源可以在一定程度上降低研发成本，提高研发效率。通过将已有研发成果汇集于开源代码库中，帮助更多开发者进行技术研发工作的开展，已是人工智能领域的惯例。2022年，在推荐算法、强化学习、机器人、可信人工智能、人工智能可解释性等领域，更多人工智能代码库开源，形成了垂直、活跃的交流社区，助力产业发展。

从研究对象看，从早期的文本、图像、音频和视频，渐渐转向3D数据模态。带来的影响是针对数字人的研究得到了空前关注。基于3D的数字人、元宇宙等内容已然成为各大科技公司争相角逐的热点内容。知识图谱是新兴的技术领域，可以广泛应用于可用图表示的各业务场景中。其底层使用的图数据库也在开源社区如火如荼的发展，包括Nebula、 Neo4j、 JanusGraph等在行业内逐步开始使用。

从产业角度看，人工智能开源项目从原本的小型应用场景（如目标检测、文字识别等）逐渐向大而全的生态系统转变，开始广泛应用于各行业和产业。

从开源单位看，企业的研究院相比高校的实验室，产出了更多有影响力的项目，国内人工智能开源项目所属单位影响力较大的百度、京东、阿里巴巴、腾讯、字节跳动、商汤、旷视等，可见各大企业近年来在不断加大开源社区生态建设方面的投入。

总体来看，国内在人工智能领域的研究日益广泛，相应的开源项目也层出不穷（见表14），许多有影响力的工作均得到了来人工智能各地开发者的贡献。

![在这里插入图片描述](https://img-blog.csdnimg.cn/d676dee31e9745dbba8a5e767faaea74.jpeg#pic_center)<br/><span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;">表14 2022年国内人工智能领域典型开源项目</span>

由图20可见，开源极大地促进了新技术的形成和新产业的落地。

![在这里插入图片描述](https://img-blog.csdnimg.cn/c7ce6b1d92744888a65adf9fdc8c2e56.png)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图20 人工智能和数据基金会交互全景图（LF AI & Data Foundation Interactive Landscape）</span>

关于人工智能发展方向，COPU名誉主席陆首群的博客《评人工智能如何走向新阶段》触发了大量“国内外AI跟帖留言”。陆首群总结出，人工智能的出路有四条（包括研发其基础理论）：①打破机器学习的黑盒子研发可解释的人工智能; ②基于异步脉冲神经网络的神经拟态计算系统; ③从知识工程出发，依托大规模语义网络（知识图谱）的支持，破解认知智能解决方案; ④脑机接口的理论和实践。目前①已有所突破，②已见亮点，③还差最后一公里，④国内外已有几十例试点。

当下，打破机器学习黑盒子研发可解释的人工智能已成为一股热潮： IBM为打破机器学习黑盒子研发可解释的人工智能，在开源社区Linux Foundation（简称LF）贡献了可信AI的关键技术，包括人工智能公平360工具箱（AIF360）；对抗性鲁棒性工具箱（ART）；人工智能可解释360工具箱（AIX360）。LF AI建立了《可信人工智能委员会》，制定了AI的基本原则，即公平性、鲁棒性、可再现性、透明性、可解释性、隐私、安全和问责。

陆首群和COPU非常关注打破机器学习黑盒子研发可解释的人工智能，其邀请IBM副总裁Todd Moore在COPU 2020和2021峰会做了两次题为基于开源的可信人工智能和人工智能可解释性的主题演讲。随后，IBM写了两篇关于基于开源的可信任的人工智能和人工智能可解释性的方法和案例（分析了三个可解释性人工智能案例：银行信贷业务、个人医疗开支、皮肤镜检查应用）。

除IBM外，马格德堡大学人工智能实验室Sebastian Stober团队也在研发可解释的人工智能技术，其研究项目的编号为CogxAI。 

从研究方向看，上述四条人工智能的出路将是人工智能的主流方向，也将是人工智能开源相关领域的发展方向。

### 3.2.3 开源与大数据
	
大数据是当今最热门的技术之一，采用分布式架构的设计思路，通过并行计算的方式来提升大规模数据分析与处理效率，同时具备高扩展能力。经过近20年的发展，大数据的技术栈逐渐成熟。国内的大数据公司可以分为两类：一类是以百度、腾讯、阿里巴巴、华为、浪潮和中兴为代表的国内领军企业，它们通过构建数据采集、数据存储、数据分析、数据安全和数据可视化的平台，具有获取和应用大数据的能力；另一类是大数据平台技术公司，它们专注于大数据技术本身的创新，针对市场需求，基于大数据工具为客户实现大数据应用解决方案。

对于大数据技术而言，拥抱开源一直是主旋律。不管是早期的几家重要的Hadoop发行版供应商如Cloudera和Hortonworks，还是云服务厂商大数据产品及服务如亚马逊EMR（Elastic Map Reduce）和Google Dataproc，都依托于大数据开源技术来提供定制化服务。硬件厂商英特尔更是基于开源的Hadoop不断在其运行的硬件上进行改进和优化，帮助用户打破Hadoop系统限制，使软硬件结合得更好。这些大数据技术供应商往往是大数据开源技术的主要共享者和完善者，因此，蓬勃发展的大数据领域不仅是一些开源技术框架，更重要的是适合技术从发展到成熟，再到形成事实标准的开源生态。而生态由开源基因决定，生态中不仅是对源代码和技术的开放，更是对标准的开放。

开源的发展让越来越多的项目可以直接采用大数据技术，新的大数据技术也会随着开源创新模式被创造。近年来，由UC Berkeley的中国学者李浩源和范斌担任核心开发者研发的虚拟分布式存储开源系统Alluxio，是发展最快的开源大数据项目之一。其基于Apache License 2.0开源，被部署应用在世界各地的多家知名公司，五年间已有超过200个组织、机构的900多名贡献者参与Alluxio的开发，包括阿里巴巴、百度、 Google、IBM、英特尔、红帽、雅虎、腾讯、南京大学、卡内基·梅隆大学、UC Berkeley。

与全球领先的大数据技术公司如Google、微软、IBM、亚马逊相比，国内的大数据技术起步较晚，但得益于国家发展战略的推动和5G、移动互联、物联网等技术的快速发展带来的数据存储量增长，国内大数据产业的支撑得到强化，应用范围加速拓展，产业规模实现快速增长。然而，在大数据管理、处理系统与工具方面，中国主要依赖于开源软件，虽然在本地应用上取得了较大的进展，但对国际开源社区的影响力仍需提升。

### 3.2.4 开源与云计算

云计算如今已是IT界的主流技术，越来越多的用户选择云计算平台作为自己软件业务的基础设施，而云计算业务带来的IT产业营收比重也越发凸显。云计算的概念从20世纪80年代发端，到真正成型落地并广为人知，开源理念和开源软件在其中起到了决定性的推动作用。

首先系统软件里，以Linux为代表的开源操作系统是云计算软件技术栈里坚实的基础，还有开源的虚拟化技术对于计算资源的池化也是必不可少的一环，包括Xen、KVM、Qemu等开源项目。云计算技术需要管理的资源，除了计算资源之外，网络资源和存储资源也是缺一不可的，同样，在网络技术软件栈和存储技术软件栈里，各种逐渐成熟的开源技术和开放标准也加速了云计算时代的到来。作为云计算产业先锋的AWS，在其稳定的技术表现和成功的商业模式带动下，一系列开源的云计算基础架构管理软件风起云涌，而时至今日，OpenStack成为唯一事实上的标准IaaS开放平台。

同时，在过去几年里，容器化和容器资源的管理也逐渐走向成熟，并快速被广大开发人员和厂商所采用，也标志了云（计算）原生时代的到来。作为云原生领域最具权威的组织，CNCF从2016年11月开始发布并持续更新云原生全景图（见图21），帮助企业和开发人员快速了解云原生体系的全貌。图21中左半部分按照层级从下至上分别是Kubernetes服务提供商、资源配置工具、运行时工具、编排与调度工具、应用开发工具，涵盖了全球云原生开源项目及其所属厂商。开源在云原生体系中起到了至关重要的作用，几乎所有的云原生技术，都有开源项目作为其代表实现或主流方案，从某种意义上讲，整个云原生体系是构建在开源上的。

![在这里插入图片描述](https://img-blog.csdnimg.cn/826d67c2bb114cbaa44ba23faf383c15.png#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>图21 CNCF云原生技术全景图</span>

与调度工具、应用开发工具，涵盖了全球云原生开源项目及其所属厂商。开源在云原生体系中起到了至关重要的作用，几乎所有的云原生技术，都有开源项目作为其代表实现或主流方案，从某种意义上讲，整个云原生体系是构建在开源上的。

近年来国内涌现出一批优秀且成熟的开源云原生项目，具有代表性的如PingCap推出的分布式事务键值数据库TiKV；阿里巴巴的云原生镜像分发系统Dragonfly、分布式内存数据管理引擎Vineyard；京东为大规模容器平台设计的分布式文件系统ChubaoFS；以及由南京大学PASALab副研究员顾荣博士、阿里云容器服务高级技术专家车漾、Alluxio 项目创始成员范斌博士联合推动发起的Fluid；腾讯的云原生服务发现和治理中心PolarisMesh、Kubernetes多集群管理项目Clusternet；华为的容器批量计算项目Volcano等。

### 3.2.5 开源与隐私计算

隐私计算作为一项可以保障数据流通过程中“原始数据不出域、数据可用不可见”的技术，成为数据要素可信流通的关键技术模式，但各闭源平台间并不互通，促使“数据孤岛”变成“计算孤岛”。而相对于不同厂商间技术路线的各自为政，基于开源框架的互联互通将更有利于隐私计算产业生态的形成。也因此，开源隐私计算技术框架成为降低企业隐私计算技术研发成本，打破“计算孤岛”，实现跨平台互联互通，推动数据要素流通重要且有效的途径。让技术在接受多维度检验的同时，建立起更加敏捷、全面的反应机制，推进技术迭代升级、平台互联互通与产业健康发展。

据中国信通院报告显示，近两年，国内外很多大厂和创业团队都在积极开源，从开源项目的活跃度和影响力来看，联邦学习的开源生态为工业化的落地应用贡献了强劲力量，特别是FATE，2020年及之后出现的很多联邦学习类产品都或多或少吸收和借鉴了FATE供给的营养。在中国信通院调研统计中，55%的国内隐私计算产品是基于或参考开源项目开发的，这其中开源项目就以FATE为主。

### 3.2.6 开源与区块链
 
由于区块链技术去中心化、多方共享、可扩展等特点，使该领域绝大多数项目都是开源的，而开源也赋能区块链领域的技术创新，近几年尤为活跃。在区块链的工具和部署方式等相关领域也拥有许多开源项目，如Hyperledger Cello和Hyperledger Caliper。

Hyperledger Cello由新华三集团（H3C）的研发人员在社区进行贡献和维护， 作为一个区块链供应和运营系统，它帮助人们以更有效的方式使用、管理区块链。基于先进的区块链技术和现代PaaS工具，提供两个主要功能：管理区块链网络的生命周期，如自动创建、启动、停止、删除、保持健康；支持自定义区块链网络配置如网络规模、共识类型。

Hyperledger Caliper由华为在Hyperledger社区发起，它是一个区块链基准框架，允许用户使用一组预定义的用例来衡量特定区块链实现的性能。Caliper生成包含许多性能指标的报告如TPS（每秒事务数）、事务延迟、资源利用率等，目的是将Caliper结果用作支持选择适合区块链实现的参考用例。 鉴于区块链配置、网络设置及特定用例的多样性，它并非旨在作为权威的性能评估，也不能用于简单的比较目的（例如，区块链A的TPS为5，而区块链B执行10 TPS，因此B更好）。

![在这里插入图片描述](https://img-blog.csdnimg.cn/1bcf628059f64423a58cb8118c4ecbf9.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表15 国内广泛使用的区块链开源项目</span>

### 3.2.7 开源与工业互联网

全球工业互联网正处于产业格局未定的关键期和规模化扩张的窗口期，各个国家围绕核心标准、技术、平台等加速布局，我国工业互联网发展也在稳步推进。据CNNIC发布的《中国互联网络发展状况统计报告》，截至2021年12月，我国有全国影响力的工业互联网平台已超150个，接入设备总量超7600万台套，在建“5G+工业互联网”项目超2000个。

作为智能制造、工业互联网的核心内容，工业软件已渗透并应用到工业领域的几乎所有核心环节，而近年来工业软件与开源的结合有力冲击了原先关键技术的垄断，为我国实现弯道超车提供了可能。在研发设计类软件、生产控制类软件、业务管理类软件和工业数据软件中，均涌现出了大量开源软件（见表16）。

![在这里插入图片描述](https://img-blog.csdnimg.cn/d2c6eda4121c4861b9cb8e50ed1ef109.jpeg#pic_center)<span style="font-size:10px;color:#707070;text-align:left !important;display: block;line-height:1.5em;"><br/>表16 由国内开发者发起或主导的优秀工业软件列表</span>

* 研发设计类：以计算机辅助设计（CAD）为例，为打破如AutoCAD等流行闭源软件的垄断，用于3D建模的FreeCAD、2D建模的LibreCAD等CAD开源软件出现。
* 生产控制类：以工业设备中常见的可编程逻辑控制器（PLC）为例，涌现出OpenPLC等PLC开源软件以及Apache PLC4X等PLC数据采集软件。
* 业务管理类：ERP、CRM类开源软件数量众多，如Apache基金会旗下的Apache OFBiz项目。
* 工业数据软件：该类别软件离IT域最近，在开源方面的成果也最为丰富，如Eclipse基金会推出的数字孪生项目Eclip。

随着开源已蔓延至工业互联网领域，我国工业软件的发展得到助力，如中望软件、中控技术、华大九天等国内企业分别推出中望CAD、DCS控制系统ECS-700X、EDA全流程工具等国产化软件。总体而言，开源加速了我国工业软件的成长速度，同时也有助于形成我国工业互联网发展新优势。
